/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ExtractingFilesModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.SelectUpdateFilesPanel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SelectUpdateFilesModel
extends WizardPanelModel {
    protected SelectUpdateFilesPanel selectUpdateFilePanel = new SelectUpdateFilesPanel(this);
    protected ProgressInfo progressInfo;
    protected Vector selectedModules;
    public static final String CANT_WRITE = "cantWrite";
    protected String lastDirectory;
    public static final String MODULE_INFO_FILENAME = "moduleinfo.dat";

    public SelectUpdateFilesModel(WizardModel wizardModel) {
        super(wizardModel);
        this.nextPanelModel = new ExtractingFilesModel(wizardModel);
    }

    public String getLastDirectory() {
        return this.lastDirectory;
    }

    public ProgressInfo getProgressInfo() {
        this.progressInfo = new ProgressInfo();
        Enumeration e = ((UpdateWizardModel)this.wizardModel).getSelectedModules().elements();
        int transferSize = 0;
        while (e.hasMoreElements()) {
            transferSize += ((ModuleInfo)e.nextElement()).getSize();
        }
        this.progressInfo.setTitle(Language.getString("wizard.update.selectModulesPanel.copying", "copying files..."));
        this.progressInfo.setMin(0);
        this.progressInfo.setMax(transferSize);
        return null;
    }

    public Vector getSelectedModules() {
        return this.selectedModules;
    }

    public WizardInputPanel getWizardInputPanel() {
        return this.selectUpdateFilePanel;
    }

    public void handleProcessException(Exception e) {
    }

    public void loadData() {
        LogoProperties props = LogoProperties.instance();
        this.lastDirectory = props.getProperty("update.selectUpdateFile.lastDirectory");
    }

    public ModuleInfo parseFile(File file) throws Exception {
        ModuleInfo moduleInfo = null;
        BufferedReader br = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry moduleInfoEntry = zipFile.getEntry(MODULE_INFO_FILENAME);
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(moduleInfoEntry)));
            String line = null;
            while ((line = br.readLine()) != null && line.startsWith("#")) {
            }
            if (line == null) {
                throw new IOException("No moduleinfo found.");
            }
            moduleInfo = new ModuleInfo(line);
            moduleInfo.setLocalSourceDirectory(file.getAbsolutePath());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            br.close();
        }
        return moduleInfo;
    }

    public void prepareData() {
        Vector lufFiles = ((UpdateWizardModel)this.wizardModel).getSelectedUpdateFiles();
        if (lufFiles != null && !lufFiles.isEmpty()) {
            this.selectedModules = new Vector();
            Enumeration e = lufFiles.elements();
            while (e.hasMoreElements()) {
                try {
                    this.selectedModules.add(this.parseFile((File)e.nextElement()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public Object process() throws Exception {
        UpdateWizardModel updateWizardModel = (UpdateWizardModel)this.wizardModel;
        File destinationPath = new File(Global.PATHBASE + "/updateTemp/");
        int transferredData = 0;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        try {
            Enumeration e = updateWizardModel.getSelectedModules().elements();
            while (e.hasMoreElements()) {
                ModuleInfo moduleInfo = (ModuleInfo)e.nextElement();
                File sourceFile = new File(moduleInfo.getLocalSourceDirectory());
                FileInputStream fis = new FileInputStream(sourceFile);
                bis = new BufferedInputStream(fis);
                File destinationFile = new File(destinationPath.getPath() + "/" + moduleInfo.getFilename());
                destinationPath.mkdirs();
                try {
                    fos = new FileOutputStream(destinationFile);
                }
                catch (IOException ioe) {
                    throw new IOException(CANT_WRITE);
                }
                byte[] data = new byte[8192];
                int readBytes = 0;
                this.progressInfo.setNote(Language.getString("wizard.update.selectModulesPanel.copying", "copying") + moduleInfo.getFilename());
                while ((readBytes = bis.read(data)) != -1) {
                    fos.write(data, 0, readBytes);
                    this.progressInfo.setCurrent(transferredData += readBytes);
                }
                moduleInfo.setLocalSourceDirectory(destinationPath.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return Boolean.TRUE;
    }

    public void setLastDirectory(String newLastDirectory) {
        this.lastDirectory = newLastDirectory;
    }

    public void setSelectedModules(Vector newSelectedModules) {
        this.selectedModules = newSelectedModules;
        ((UpdateWizardModel)this.wizardModel).setSelectedModules(newSelectedModules);
    }

    public void storeData() {
        LogoProperties props = LogoProperties.instance();
        props.setProperty("update.selectUpdateFile.lastDirectory", this.lastDirectory);
        props.saveProperties();
    }
}

